jQuery(document).ready(function($) {
    'use strict';
    
    // Test FTP connection
    $('#test-ftp-connection').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var $result = $('#ftp-test-result');
        
        // Disable button and show loading
        $button.prop('disabled', true).text('Testing...');
        $result.hide();
        
        // Get form data
        var formData = {
            action: 'test_ftp_connection',
            nonce: ftp_media_admin.nonce,
            settings: {
                ftp_host: $('input[name="ftp_media_settings[ftp_host]"]').val(),
                ftp_username: $('input[name="ftp_media_settings[ftp_username]"]').val(),
                ftp_password: $('input[name="ftp_media_settings[ftp_password]"]').val(),
                ftp_port: $('input[name="ftp_media_settings[ftp_port]"]').val(),
                ftp_directory: $('input[name="ftp_media_settings[ftp_directory]"]').val(),
                ftp_passive: $('input[name="ftp_media_settings[ftp_passive]"]').is(':checked')
            }
        };
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: formData,
            timeout: 30000,
            success: function(response) {
                // Handle response
                var isSuccess = response.success === true;
                var message = response.data || 'No message provided';
                
                if (isSuccess) {
                    $result.removeClass('error').addClass('success')
                          .html('<strong>✓ Success:</strong> ' + message)
                          .show();
                    $('.ftp-troubleshooting').hide();
                } else {
                    $result.removeClass('success').addClass('error')
                          .html('<strong>✗ Error:</strong> ' + message)
                          .show();
                    $('.ftp-troubleshooting').show();
                }
            },
            error: function(xhr, status, error) {
                var errorMessage = 'Failed to test connection';
                
                if (status === 'timeout') {
                    errorMessage = 'Connection test timed out. Please check your FTP server settings and try again.';
                } else if (xhr.responseJSON && xhr.responseJSON.data) {
                    errorMessage = xhr.responseJSON.data;
                } else if (error) {
                    errorMessage = 'Network error: ' + error;
                }
                
                $result.removeClass('success').addClass('error')
                      .html('<strong>✗ Error:</strong> ' + errorMessage)
                      .show();
                $('.ftp-troubleshooting').show();
            },
            complete: function() {
                $button.prop('disabled', false).text('Test Connection');
            }
        });
    });
    
    // Test FTP operations
    $('#test-ftp-operations').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var $result = $('#ftp-test-result');
        
        // Disable button and show loading
        $button.prop('disabled', true).text('Testing...');
        $result.hide();
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'test_ftp_operations',
                nonce: ftp_media_admin.nonce
            },
            timeout: 30000,
            success: function(response) {
                var isSuccess = response.success === true;
                var message = response.data || 'No message provided';
                
                if (isSuccess) {
                    $result.removeClass('error').addClass('success')
                          .html('<strong>✓ Success:</strong> ' + message)
                          .show();
                } else {
                    $result.removeClass('success').addClass('error')
                          .html('<strong>✗ Error:</strong> ' + message)
                          .show();
                }
            },
            error: function(xhr, status, error) {
                var errorMessage = 'Failed to test FTP operations';
                
                if (status === 'timeout') {
                    errorMessage = 'FTP operations test timed out.';
                } else if (xhr.responseJSON && xhr.responseJSON.data) {
                    errorMessage = xhr.responseJSON.data;
                } else if (error) {
                    errorMessage = 'Network error: ' + error;
                }
                
                $result.removeClass('success').addClass('error')
                      .html('<strong>✗ Error:</strong> ' + errorMessage)
                      .show();
            },
            complete: function() {
                $button.prop('disabled', false).text('Test FTP Operations');
            }
        });
    });
    
    // Migrate FTP to Local
    $('#migrate-ftp-to-local').on('click', function(e) {
        e.preventDefault();
        
        if (!confirm('Are you sure you want to migrate all FTP URLs to local? This action cannot be undone. Make sure you have manually downloaded all files to your local server first.')) {
            return;
        }
        
        var $button = $(this);
        var $result = $('#migration-result');
        
        // Disable button and show loading
        $button.prop('disabled', true).text('Migrating...');
        $result.hide();
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'migrate_ftp_to_local',
                nonce: ftp_media_admin.nonce
            },
            timeout: 60000, // 60 seconds timeout for this operation
            success: function(response) {
                var isSuccess = response.success === true;
                var message = response.data && response.data.message ? response.data.message : 'Migration completed';
                
                if (isSuccess) {
                    var details = '';
                    if (response.data && response.data.updated !== undefined) {
                        details = '<br>Updated: ' + response.data.updated + ' files';
                        if (response.data.failed > 0) {
                            details += '<br>Failed: ' + response.data.failed + ' files (files may not exist locally)';
                        }
                    }
                    
                    $result.removeClass('error').addClass('notice notice-success')
                          .html('<p><strong>✓ ' + message + '</strong>' + details + '</p>')
                          .show();
                } else {
                    $result.removeClass('notice-success').addClass('notice notice-error')
                          .html('<p><strong>✗ ' + message + '</strong></p>')
                          .show();
                }
            },
            error: function(xhr, status, error) {
                var errorMessage = 'Migration failed';
                
                if (status === 'timeout') {
                    errorMessage = 'Migration timed out. Please try again.';
                } else if (xhr.responseJSON && xhr.responseJSON.data) {
                    errorMessage = xhr.responseJSON.data;
                } else if (error) {
                    errorMessage = 'Network error: ' + error;
                }
                
                $result.removeClass('notice-success').addClass('notice notice-error')
                      .html('<p><strong>✗ ' + errorMessage + '</strong></p>')
                      .show();
            },
            complete: function() {
                $button.prop('disabled', false).text('Migrate FTP URLs to Local');
            }
        });
    });
    
});
