<?php
/**
 * Plugin Name: FTP Media
 * Plugin URI: https://yourwebsite.com/ftp-media
 * Description: Upload WordPress media files to external FTP server to reduce server load and storage consumption.
 * Version: 1.0.0
 * Author: milad
 * License: GPL v2 or later
 * Text Domain: ftp-media
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('FTP_MEDIA_VERSION', '1.0.0');
define('FTP_MEDIA_PLUGIN_URL', plugin_dir_url(__FILE__));
define('FTP_MEDIA_PLUGIN_PATH', plugin_dir_path(__FILE__));

// Include required files
require_once FTP_MEDIA_PLUGIN_PATH . 'includes/class-ftp-media.php';
require_once FTP_MEDIA_PLUGIN_PATH . 'includes/class-ftp-settings.php';
require_once FTP_MEDIA_PLUGIN_PATH . 'includes/class-ftp-uploader.php';
require_once FTP_MEDIA_PLUGIN_PATH . 'includes/class-ftp-logger.php';
require_once FTP_MEDIA_PLUGIN_PATH . 'includes/class-ftp-importer.php';

// Initialize the plugin
function ftp_media_init() {
    new FTP_Media();
}
add_action('plugins_loaded', 'ftp_media_init');

// Activation hook
register_activation_hook(__FILE__, 'ftp_media_activate');
function ftp_media_activate() {
    // Create default options
    add_option('ftp_media_settings', array(
        'ftp_host' => '',
        'ftp_username' => '',
        'ftp_password' => '',
        'ftp_port' => 21,
        'ftp_passive' => true,
        'ftp_ssl' => false,
        'ftp_directory' => '/',
        'ftp_url' => '',
        'enabled' => false
    ));
}

// Deactivation hook
register_deactivation_hook(__FILE__, 'ftp_media_deactivate');
function ftp_media_deactivate() {
    // Clean up if needed
}
