<?php
/**
 * Uninstall script for FTP Media plugin
 */

// If uninstall not called from WordPress, then exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Remove plugin options
delete_option('ftp_media_settings');

// Remove any custom database tables if they exist
// (Currently no custom tables are created)

// Remove log files
$upload_dir = wp_upload_dir();
$log_file = $upload_dir['basedir'] . '/ftp-media.log';
if (file_exists($log_file)) {
    unlink($log_file);
}

// Clear any cached data
wp_cache_flush();
